<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class IsAdmin
{
  /**
   * Handle an incoming request.
   *
   * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
   */
  public function handle(Request $request, Closure $next): Response
  {
    if (!Auth::check()) {
      return redirect()->route('login')->with('error', 'Please login to access this page.');
    }
    if (!Auth::user()->isAdmin()) {
      return redirect()->route('home')->with('error', '⛔ You do not have permission to access this page.');
    }

    return $next($request);
  }
}
